function layout()
return {

forceFeedback = {
trimmer = 1.0,
shake = 0.5,
swapAxes = false,
},

keyCommands = {
{down = ICommandToggleConsole, name = 'Toggle Console', category = 'Debug'},
{down = iCommandActivePauseOnOff, name = 'Active Pause', category = 'Cheat'},

-- View                                                    
{combos = {{key = 'JOY_BTN_POV1_L'}}, pressed = iCommandViewLeftSlow, up = iCommandViewStopSlow, name = 'View Left slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_R'}}, pressed = iCommandViewRightSlow, up = iCommandViewStopSlow, name = 'View Right slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_U'}}, pressed = iCommandViewUpSlow, up = iCommandViewStopSlow, name = 'View Up slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_D'}}, pressed = iCommandViewDownSlow, up = iCommandViewStopSlow, name = 'View Down slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_UR'}}, pressed = iCommandViewUpRightSlow, up = iCommandViewStopSlow, name = 'View Up Right slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_DR'}}, pressed = iCommandViewDownRightSlow, up = iCommandViewStopSlow, name = 'View Down Right slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_DL'}}, pressed = iCommandViewDownLeftSlow, up = iCommandViewStopSlow, name = 'View Down Left slow', category = 'View'},
{combos = {{key = 'JOY_BTN_POV1_UL'}}, pressed = iCommandViewUpLeftSlow, up = iCommandViewStopSlow, name = 'View Up Left slow', category = 'View'},
{combos = {{key = 'JOY_BTN5'}}, pressed = iCommandViewCenter, name = 'View Center', category = 'View'},


{pressed = iCommandViewForwardSlow, up = iCommandViewForwardSlowStop, name = 'Zoom in slow', category = 'View'},
{pressed = iCommandViewBackSlow, up = iCommandViewBackSlowStop, name = 'Zoom out slow', category = 'View'},
{down = iCommandViewAngleDefault, name = 'Zoom normal', category = 'View'},
{pressed = iCommandViewExternalZoomIn, up = iCommandViewExternalZoomInStop, name = 'Zoom external in', category = 'View'},
{pressed = iCommandViewExternalZoomOut, up = iCommandViewExternalZoomOutStop, name = 'Zoom external out', category = 'View'},
{down = iCommandViewExternalZoomDefault, name = 'Zoom external normal', category = 'View'},
{down = iCommandViewSpeedUp, name = 'F11 camera moving forward', category = 'View'},
{down = iCommandViewSlowDown, name = 'F11 camera moving backward', category = 'View'},

{down = iCommandViewCockpit, name = 'F1 Cockpit view', category = 'View'},
{down = iCommandNaturalViewCockpitIn, name = 'F1 Natural head movement view', category = 'View'},
{down = iCommandViewHUDOnlyOnOff, name = 'F1 HUD only view switch', category = 'View'},
{down = iCommandViewAir, name = 'F2 Aircraft view', category = 'View'},
{down = iCommandViewMe, name = 'F2 View own aircraft', category = 'View'},
{down = iCommandViewFromTo, name = 'F2 Toggle camera position', category = 'View'},
{down = iCommandViewLocal, name = 'F2 Toggle local camera control', category = 'View'},
{down = iCommandViewTower, name = 'F3 Fly-By view', category = 'View'},
{down = iCommandViewTowerJump, name = 'F3 Fly-By jump view', category = 'View'},
{down = iCommandViewRear, name = 'F4 Look back view', category = 'View'},
{down = iCommandViewChase, name = 'F4 Chase view', category = 'View'},
{down = iCommandViewChaseArcade, name = 'F4 Arcade View', category = 'View'},
{down = iCommandViewFight, name = 'F5 nearest AC view', category = 'View'},
{down = iCommandViewFightGround, name = 'F5 Ground hostile view', category = 'View'},
{down = iCommandViewWeapons, name = 'F6 Released weapon view', category = 'View'},
{down = iCommandViewWeaponAndTarget, name = 'F6 Weapon to target view', category = 'View'},
{down = iCommandViewGround, name = 'F7 Ground unit view', category = 'View'},
{down = iCommandViewJFO, name = 'F7 Ground JFO/JTAC view', category = 'View'},
{down = iCommandViewNavy, name = 'F9 Ship view', category = 'View'},
{down = iCommandViewLndgOfficer, name = 'F9 Landing signal officer view', category = 'View'},
{down = iCommandViewAWACS, name = 'F10 Theater map view', category = 'View'},
{down = iCommandViewAWACSJump, name = 'F10 Jump to theater map view over current point', category = 'View'},
{down = iCommandViewFree, name = 'F11 Airport free camera', category = 'View'},
{down = iCommandViewFreeJump, name = 'F11 Jump to free camera', category = 'View'},
{down = iCommandViewStatic, name = 'F12 Static object view', category = 'View'},
{down = iCommandViewMirage, name = 'F12 Civil traffic view', category = 'View'},
{down = iCommandViewLocomotivesToggle, name = 'F12 Trains/cars toggle', category = 'View'},
{down = iCommandViewPitHeadOnOff, name = 'F1 Head shift movement on / off', category = 'View'},

{down = iCommandViewFastKeyboard, name = 'Fast keyboard turn speed', category = 'View'},
{down = iCommandViewSlowKeyboard, name = 'Slow keyboard turn speed', category = 'View'},
{down = iCommandViewNormalKeyboard, name = 'Normal keyboard turn speed', category = 'View'},
{down =  iCommandViewFastMouse, name = 'Fast mouse turn speed', category = 'View'},
{down = iCommandViewSlowMouse, name = 'Slow mouse turn speed', category = 'View'},
{down = iCommandViewNormalMouse, name = 'Normal mouse turn speed', category = 'View'},


-- Cockpit view
{down = iCommandViewTempCockpitOn, up = iCommandViewTempCockpitOff, name = 'Cockpit panel view in', category = 'View Cockpit'},
{down = iCommandViewTempCockpitToggle, name = 'Cockpit panel view toggle', category = 'View Cockpit'},
--
{ down = iCommandViewSaveAngles, name = 'Save Cockpit Angles', category = 'View Cockpit'},
{ pressed = iCommandViewUp, up = iCommandViewStop, name = 'View up', category = 'View Cockpit'},
{ pressed = iCommandViewDown, up = iCommandViewStop, name = 'View down', category = 'View Cockpit'},
{ pressed = iCommandViewLeft, up = iCommandViewStop, name = 'View left', category = 'View Cockpit'},
{ pressed = iCommandViewRight, up = iCommandViewStop, name = 'View right', category = 'View Cockpit'},
{ pressed = iCommandViewUpRight, up = iCommandViewStop, name = 'View up right', category = 'View Cockpit'},
{ pressed = iCommandViewDownRight, up = iCommandViewStop, name = 'View down right', category = 'View Cockpit'},
{ pressed = iCommandViewDownLeft, up = iCommandViewStop, name = 'View down left', category = 'View Cockpit'},
{ pressed = iCommandViewUpLeft, up = iCommandViewStop, name = 'View up left', category = 'View Cockpit'},

{down = iCommandViewCameraUp, up = iCommandViewCameraCenter, name = 'Camera view up', category = 'View Cockpit'},
{down = iCommandViewCameraDown, up = iCommandViewCameraCenter, name = 'Camera view down', category = 'View Cockpit'},
{down = iCommandViewCameraLeft, up = iCommandViewCameraCenter, name = 'Camera view left', category = 'View Cockpit'},
{down = iCommandViewCameraRight, up = iCommandViewCameraCenter, name = 'Camera view right', category = 'View Cockpit'},
{down = iCommandViewCameraUpLeft, up = iCommandViewCameraCenter, name = 'Camera view up-left', category = 'View Cockpit'},
{down = iCommandViewCameraDownLeft, up = iCommandViewCameraCenter, name = 'Camera view down-left', category = 'View Cockpit'},
{down = iCommandViewCameraUpRight, up = iCommandViewCameraCenter, name = 'Camera view up-right', category = 'View Cockpit'},
{down = iCommandViewCameraDownRight, up = iCommandViewCameraCenter, name = 'Camera view down-right', category = 'View Cockpit'},

{down = iCommandViewCameraUpSlow, name = 'Camera view up slow', category = 'View Cockpit'},
{down = iCommandViewCameraDownSlow, name = 'Camera view down slow', category = 'View Cockpit'},
{down = iCommandViewCameraLeftSlow, name = 'Camera view left slow', category = 'View Cockpit'},
{down = iCommandViewCameraRightSlow, name = 'Camera view right slow', category = 'View Cockpit'},
{down = iCommandViewCameraUpLeftSlow, name = 'Camera view up-left slow', category = 'View Cockpit'},
{down = iCommandViewCameraDownLeftSlow, name = 'Camera view down-left slow', category = 'View Cockpit'},
{down = iCommandViewCameraDownRight, name = 'Camera view up-right slow', category = 'View Cockpit'},
{down = iCommandViewCameraUpRightSlow, name = 'Camera view down-right slow', category = 'View Cockpit'},
{down = iCommandViewCameraCenter, name = 'Center camera view', category = 'View Cockpit'},
{down = iCommandViewCameraReturn, name = 'Return camera', category = 'View Cockpit'},
{down = iCommandViewCameraBaseReturn, name = 'Return camera base', category = 'View Cockpit'},

{down = iCommandViewSnapView0,	up = iCommandViewSnapViewStop, name = 'Snap View 0', category = 'View Cockpit'},
{down = iCommandViewSnapView1,	up = iCommandViewSnapViewStop, name = 'Snap View 1', category = 'View Cockpit'},
{down = iCommandViewSnapView2,	up = iCommandViewSnapViewStop, name = 'Snap View 2', category = 'View Cockpit'},
{down = iCommandViewSnapView3,	up = iCommandViewSnapViewStop, name = 'Snap View 3', category = 'View Cockpit'},
{down = iCommandViewSnapView4,	up = iCommandViewSnapViewStop, name = 'Snap View 4', category = 'View Cockpit'},
{down = iCommandViewSnapView5,	up = iCommandViewSnapViewStop, name = 'Snap View 5', category = 'View Cockpit'},
{down = iCommandViewSnapView6,	up = iCommandViewSnapViewStop, name = 'Snap View 6', category = 'View Cockpit'},
{down = iCommandViewSnapView7,	up = iCommandViewSnapViewStop, name = 'Snap View 7', category = 'View Cockpit'},
{down = iCommandViewSnapView8,	up = iCommandViewSnapViewStop, name = 'Snap View 8', category = 'View Cockpit'},
{down = iCommandViewSnapView9,	up = iCommandViewSnapViewStop, name = 'Snap View 9', category = 'View Cockpit'},

{down = iCommandViewLeftMirrorOn ,	up = iCommandViewLeftMirrorOff , name = 'Left Mirror On', category = 'View Cockpit'},
{down = iCommandViewRightMirrorOn,	up = iCommandViewRightMirrorOff, name = 'Right Mirror On', category = 'View Cockpit'},

{pressed = iCommandViewForward, up = iCommandViewForwardStop, name = 'Zoom in', category = 'View Cockpit'},
{pressed = iCommandViewBack, up = iCommandViewBackStop, name = 'Zoom out', category = 'View Cockpit'},

-- Cockpit Camera Motion (   )
{pressed = iCommandViewPitCameraMoveUp, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Up', category = 'View Cockpit'},
{pressed = iCommandViewPitCameraMoveDown, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Down', category = 'View Cockpit'},
{pressed = iCommandViewPitCameraMoveLeft, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Left', category = 'View Cockpit'},
{pressed = iCommandViewPitCameraMoveRight, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Right', category = 'View Cockpit'},
{pressed = iCommandViewPitCameraMoveForward, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Forward', category = 'View Cockpit'},
{pressed = iCommandViewPitCameraMoveBack, up = iCommandViewPitCameraMoveStop, name = 'Cockpit Camera Move Back', category = 'View Cockpit'},
{down = iCommandViewPitCameraMoveCenter, name = 'Cockpit Camera Move Center', category = 'View Cockpit'},

-- Extended view
{down = iCommandViewCameraJiggle, name = 'Camera jiggle toggle', category = 'View Extended'},
{down = iCommandViewKeepTerrain, name = 'Keep terrain camera altitude', category = 'View Extended'},
{down = iCommandViewFriends, name = 'View friends mode', category = 'View Extended'},
{down = iCommandViewEnemies, name = 'View enemies mode', category = 'View Extended'},
{down = iCommandViewAll, name = 'View all mode', category = 'View Extended'},
{down = iCommandViewPlus, name = 'Toggle tracking fire weapon', category = 'View Extended'},
{down = iCommandViewSwitchForward, name = 'Objects switching direction forward ', category = 'View Extended'},
{down = iCommandViewSwitchReverse, name = 'Objects switching direction reverse ', category = 'View Extended'},
{down = iCommandViewObjectIgnore, name = 'Object exclude ', category = 'View Extended'},
{down = iCommandViewObjectsAll, name = 'Objects all excluded - include', category = 'View Extended'},

--General
{down = iCommandQuit, name = 'End mission', category = 'General'},
{down = iCommandBrakeGo, name = 'Pause', category = 'General'},
{down = iCommandAccelerate, name = 'Time accelerate', category = 'General'},
{down = iCommandDecelerate, name = 'Time decelerate', category = 'General'},
{down = iCommandNoAcceleration, name = 'Time normal', category = 'General'},
{down = iCommandScoresWindowToggle, name = 'Score window', category = 'General'},
{down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
{down = iCommandRecoverHuman, name = 'Get new plane - respawn', category = 'General'},
{down = iCommandScreenShot, name = 'Screenshot', category = 'General'},
{down = iCommandTrkEsc, name = 'Playback track cancel', category = 'General'},
{down = iCommandInfoOnOff, name = 'Info bar view toggle', category = 'General'},
{down = iCommandOneFrame, name = 'One frame mode', category = 'General'},
{down = iCommandGraphicsFrameRate, name = 'Frame rate counter - Service info', category = 'General'},
{down = iCommandViewCoordinatesInLinearUnits, name = 'Coordinates units change', category = 'General'},
{down = iCommandChat, name = 'Multiplayer chat - mode All', category = 'General'},
{down = iCommandFriendlyChat, name = 'Multiplayer chat - mode Allies', category = 'General'},
{down = iCommandCockpitClickModeOnOff, name = 'Clickable mouse cockpit mode On/Off', category = 'General'},
{down = iCommandPlane_ShowControls, name = 'Show controls indicator' , category = 'General'},


-- Communications
{down = iCommandPlaneDoAndHome, name = 'Dispatch wingmans - complete mission and RTB', category = 'Communications'},
{down = iCommandPlaneDoAndBack, name = 'Dispatch wingmans - complete mission and rejoin', category = 'Communications'},
{down = iCommandPlaneFormation, name = 'Toggle formation', category = 'Communications'},
{down = iCommandPlaneJoinUp, name = 'Join up formation', category = 'Communications'},
{down = iCommandPlaneAttackMyTarget, name = 'Attack my target', category = 'Communications'},
{down = iCommandPlaneCoverMySix, name = 'Cover me', category = 'Communications'},
{down = iCommandAWACSHomeBearing, name = 'Ask AWACS home airbase', category = 'Communications'},
{down = iCommandAWACSTankerBearing, name = 'Ask AWACS available tanker', category = 'Communications'},
{down = iCommandPlane_EngageGroundTargets, name = 'Attack Ground Targets', category = 'Communications'},
{down = iCommandPlane_EngageAirDefenses, name = 'Attack Air Defenses', category = 'Communications'},
{down = iCommandToggleCommandMenu, name = 'Communication menu', category = 'Communications'},
{down = ICommandSwitchDialog, name = 'Switch dialog', category = 'Communications'},


-- Padlock

{down = iCommandViewLock, name = 'Lock view (cycle padlock)', category = 'View Padlock'},
{down = iCommandAllMissilePadlock, name = 'All missiles padlock', category = 'View Padlock'},
{down = iCommandThreatMissilePadlock, name = 'Threat missile padlock', category = 'View Padlock'},
{down = iCommandViewUnlock, name = 'Unlock view (stop padlock)', category = 'View Padlock'},
{down = iCommandViewTerrainLock, name = 'Lock terrain view', category = 'View Padlock'},
{down = iCommandPlaneQuickPadlockOn, up = iCommandPlaneQuickPadlockOff, name = 'Quick Padlock', category = 'View Padlock'},


-- Labels
{down = iCommandMarkerState, name = 'All Labels', category = 'Labels'},
{down = iCommandMarkerStatePlane, name = 'Aircraft Labels', category = 'Labels'},
{down = iCommandMarkerStateRocket, name = 'Missile Labels', category = 'Labels'},
{down = iCommandMarkerStateShip, name = 'Vehicle & Ship Labels', category = 'Labels'},


-- HOTAS
{combos = {{key = 'JOY_BTN2'}}, 	down = iCommandPlanePickleOn, up = iCommandPlanePickleOff, name = 'Weapon release', category = 'HOTAS'},
{combos = {{key = 'JOY_BTN1'}}, 	down = iCommandPlane_HOTAS_TriggerSecondStage, up = iCommandPlane_HOTAS_TriggerSecondStage_Off, name = 'Gun Trigger', category = 'HOTAS'},
{					down = iCommandPlane_HOTAS_TriggerFirstStage , up = iCommandPlane_HOTAS_TriggerFirstStage_Off, name = 'Gun Trigger (first stage)', category = 'HOTAS'},


{down = iCommandPlane_HOTAS_DataManagementSwitchUp,    up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Forward',    category = 'HOTAS'},
{down = iCommandPlane_HOTAS_DataManagementSwitchDown,  up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Aft',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_DataManagementSwitchLeft,  up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Left',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_DataManagementSwitchRight, up = iCommandPlane_HOTAS_DataManagementSwitchOff, name = 'HOTAS DMS Right', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_TargetManagementSwitchUp,    up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Forward',    category = 'HOTAS'},
{down = iCommandPlane_HOTAS_TargetManagementSwitchDown,  up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Aft',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_TargetManagementSwitchLeft,  up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Left',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_TargetManagementSwitchRight, up = iCommandPlane_HOTAS_TargetManagementSwitchOff, name = 'HOTAS TMS Right', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_CMS_Up   , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Forward', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CMS_Down , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Aft',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CMS_Left , up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Left',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CMS_Right, up = iCommandPlane_HOTAS_CMS_Off, name = 'HOTAS CMS Right', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CMS_Zaxis, up = iCommandPlane_HOTAS_CMS_Zaxis_Off, name = 'HOTAS CMS Z Axis', category = 'HOTAS'},

{pressed = iCommandPlaneRadarUp, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Up', category = 'HOTAS'},
{pressed = iCommandPlaneRadarDown, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Down', category = 'HOTAS'},
{pressed = iCommandPlaneRadarLeft, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Left', category = 'HOTAS'},
{pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = 'HOTAS Slew Right', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_CoolieUp,    up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Up',    category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CoolieDown,  up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Down',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CoolieLeft,  up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Left',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_CoolieRight, up = iCommandPlane_HOTAS_CoolieOff, name = 'HOTAS Coolie Switch Right', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_BoatSwitchAft, name = 'HOTAS Boat Switch Aft', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_BoatSwitchCenter, name = 'HOTAS Boat Switch Center', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_BoatSwitchForward, name = 'HOTAS Boat Switch Forward', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_ChinaHatAft, up = iCommandPlane_HOTAS_ChinaHatOff, name = 'HOTAS China Hat Aft', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_ChinaHatForward, up = iCommandPlane_HOTAS_ChinaHatOff, name = 'HOTAS China Hat Forward', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_LeftThrottleButton, name = 'HOTAS Left Throttle Button', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_MasterModeControlButton, up = iCommandPlane_HOTAS_MasterModeControlButtonUP, name = 'HOTAS Master Mode Control Button', category = 'HOTAS'},
{combos = {{key = 'JOY_BTN4'}},	down = iCommandPlane_HOTAS_NoseWheelSteeringButton, up = iCommandPlane_HOTAS_NoseWheelSteeringButtonOff, name = 'HOTAS Nosewheel Steering Button', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_SpeedBrakeSwitchAft, up = iCommandPlane_HOTAS_SpeedBrakeSwitchCenter, name = 'HOTAS Speed Brake Switch Aft', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_SpeedBrakeSwitchForward, up = iCommandPlane_HOTAS_SpeedBrakeSwitchCenter, name = 'HOTAS Speed Brake Switch Forward', category = 'HOTAS'},

{down = iCommandPlane_HOTAS_PinkySwitchAft,  	name = 'HOTAS Pinky Switch Aft',     category = 'HOTAS'},
{down = iCommandPlane_HOTAS_PinkySwitchForward, name = 'HOTAS Pinky Switch Forward', category = 'HOTAS'},
{down = iCommandPlane_HOTAS_PinkySwitchCenter , name = 'HOTAS Pinky Switch Center',  category = 'HOTAS'},

{down = iCommandPlane_HOTAS_MIC_SwitchUp,    up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Up',    category = 'HOTAS'},
{down = iCommandPlane_HOTAS_MIC_SwitchDown,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Down',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_MIC_SwitchLeft,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Aft',  category = 'HOTAS'},
{down = iCommandPlane_HOTAS_MIC_SwitchRight, up = iCommandPlane_HOTAS_MIC_SwitchOff, name = 'HOTAS MIC Switch Forward', category = 'HOTAS'},

{pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop,    name = 'Trim: Nose Down',	     category = 'HOTAS'},
{pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop,  name = 'Trim: Nose Up',			 category = 'HOTAS'},
{pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop,  name = 'Trim: Left Wing Down',   category = 'HOTAS'},
{pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = 'Trim: Right Wing Down',  category = 'HOTAS'},

{pressed = iCommandPlaneEmergencyDisconnectLever, name = 'Emergency Disconnect Lever', category = 'HOTAS'},

-- Flight Control
{combos = {{key = 'JOY_BTN3'}}, down = iCommandPlaneTrimOn, up = iCommandPlaneTrimOff, name = 'Stick to trimmer control mode', category = 'Flight Control'},

{pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = 'Trim Left Rudder', category = 'Flight Control'},
{pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = 'Trim Right Rudder', category = 'Flight Control'},

{down = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = 'Fly (pitch down)', category = 'Flight Control'},
{down = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = 'Fly (pitch up)', category = 'Flight Control'},
{down = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = 'Fly (roll left)', category = 'Flight Control'},
{down = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = 'Fly (roll right)', category = 'Flight Control'},
{down = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = 'Rudder left', category = 'Flight Control'},
{down = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = 'Rudder right', category = 'Flight Control'},
{down = iCommandPlaneTrimCancel, name = 'Reset Trimmers', category = 'Flight Control'},

{down = iCommandThrottleIncrease,	up = iCommandThrottleStop,	name = 'Throttle Common Up', category = 'Flight Control'},
{down = iCommandThrottleDecrease,	up = iCommandThrottleStop,	name = 'Throttle Common Down', category = 'Flight Control'},
{down = iCommandThrottle1Increase,	up = iCommandThrottle1Stop,	name = 'Throttle Left Up', category = 'Flight Control'},
{down = iCommandThrottle1Decrease,	up = iCommandThrottle1Stop,	name = 'Throttle Left Down', category = 'Flight Control'},
{down = iCommandThrottle2Increase,	up = iCommandThrottle2Stop,	name = 'Throttle Right Up', category = 'Flight Control'},
{down = iCommandThrottle2Decrease,	up = iCommandThrottle2Stop,	name = 'Throttle Right Down', category = 'Flight Control'},
{down = iCommandPlaneAUTIncreaseRegimeLeft,					name = 'Throttle Left Up Step', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseRegimeLeft,					name = 'Throttle Left Down Step', category = 'Flight Control'},
{down = iCommandPlaneAUTIncreaseRegimeRight,					name = 'Throttle Right Up Step', category = 'Flight Control'},
{down = iCommandPlaneAUTDecreaseRegimeRight,					name = 'Throttle Right Down Step', category = 'Flight Control'},


{down    = iCommandPlaneAUTIncreaseRegime	, name = 'Thrust Up', category = 'Flight Control'},
{down    = iCommandPlaneAUTDecreaseRegime	, name = 'Thrust Down', category = 'Flight Control'},
{pressed = iCommandPlaneAUTIncreaseLeft		, name = 'Power Up Left', category = 'Flight Control'},
{pressed = iCommandPlaneAUTDecreaseLeft		, name = 'Power Down Left', category = 'Flight Control'},
{pressed = iCommandPlaneAUTIncreaseRight	, name = 'Power Up Right', category = 'Flight Control'},
{pressed = iCommandPlaneAUTDecreaseRight	, name = 'Power Down Right', category = 'Flight Control'},
{down    = iCommandPlaneAUTIncreaseRegimeLeft	, name = 'Thrust Up Left', category = 'Flight Control'},
{down    = iCommandPlaneAUTDecreaseRegimeLeft	, name = 'Thrust Down Left', category = 'Flight Control'},
{down    = iCommandPlaneAUTIncreaseRegimeRight	, name = 'Thrust Up Right', category = 'Flight Control'},
{down    = iCommandPlaneAUTDecreaseRegimeRight	, name = 'Thrust Down Right', category = 'Flight Control'},


-- Systems
{down = iCommandPlaneGear, name = 'Toggle Landing Gear Up/Down', category = 'Systems'},
{down = iCommandPlaneGearUp, name = 'Toggle Landing Gear Up', category = 'Systems'},
{down = iCommandPlaneGearDown, name = 'Toggle Landing Gear Down', category = 'Systems'},
{down = iCommandPlaneHook, name = 'Toggle Arrestor Hook', category = 'Systems'},
{down = iCommandEmergencyGear, name = 'Emeregency gear', category = 'Systems'},
{down = iCommandPlaneFlaps   , name = 'Toggle Flaps Up/Down', category = 'Systems'},
{down = iCommandPlaneFlapsOn , name = 'Flaps Down To The Landing Position', category = 'Systems'},
{down = iCommandPlaneFlapsOff, name = 'Flaps Up', category = 'Systems'},
{down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = 'Wheel Brake On/Off', category = 'Systems'},
{down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = 'Wheel Brake Left On/Off', category = 'Systems'},
{down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = 'Wheel Brake Right On/Off', category = 'Systems'},
{down = iCommandPlaneEmergencyBrake, name = 'Emergency Wheel Brake', category = 'Systems'},
{down = iCommandEnginesStart, name = 'Start Engines', category = 'Systems'},
{down = iCommandLeftEngineStart, name = 'Left Engine Start', category = 'Systems'},
{down = iCommandRightEngineStart, name = 'Right Engine Start', category = 'Systems'},
{down = iCommandEnginesStop, name = 'Stop Engines' , category = 'Systems'},

{down = iCommandLeftEngineStop, name = 'Left Engine Stop', category = 'Systems'},
{down = iCommandRightEngineStop, name = 'Right Engine Stop', category = 'Systems'},
{down = iCommandPlaneJettisonFuelTanks				 , name = 'Jettison Fuel Tanks', category = 'Systems'},
{down = iCommandPlaneFonar, name = 'Canopy Open/Close', category = 'Systems'},
{down = iCommandPlaneEject, name = 'Eject', category = 'Systems'},
{down = iCommandPlaneCockpitIllumination, name = 'Cockpit Illumination', category = 'Systems'},
{down = iCommandPlaneHeadLightOnOff, name = 'Toggle Gear Light Near/Far/Off', category = 'Systems'},
{down = iCommandPlaneLightsOnOff, name = 'Toggle Navigation lights', category = 'Systems'},
{down = iCommandPlaneWingtipSmokeOnOff, name = 'Toggle Smoke', category = 'Systems'},
{down = iCommandPlaneResetMasterWarning, name = 'Reset Current Audible Warning', category = 'Systems'},
{down = iCommandPlaneJettisonWeapons, name = 'Jettison Weapons', category = 'Systems'},
{down = iCommandFlightClockReset, name = 'Start/Stop/Reset Flight Clock', category = 'Systems'},
{down = iCommandBrightnessILS, name = 'HUD Color', category = 'Systems'},

-- Autopilot
{down = iCommandPlaneAutopilot, up = iCommandPlaneAutopilot, name 		= 'LAAP Engage/Disengage'     , category = 'LASTE Control Panel'},
{down = iCommandPlaneStabPathHold, name 	= 'LAAP Path Hold'			  , category = 'LASTE Control Panel'},
{down = iCommandPlaneStabHbarHeading, name  = 'LAAP Altitude/Heading Hold', category = 'LASTE Control Panel'},
{down = iCommandPlaneStabHbarBank, name 	= 'LAAP Altitude/Bank Hold'   , category = 'LASTE Control Panel'},
{down = iCommandPlane_EAC_ARM, name 		= 'EAC Arm'					  , category = 'LASTE Control Panel'},
{down = iCommandPlane_EAC_OFF, name 		= 'EAC Off'					  , category = 'LASTE Control Panel'},
{down = iCommandPlane_RDR_ALTM_NRM, name 	= 'RDR ALTM Normal'			  , category = 'LASTE Control Panel'},
{down = iCommandPlane_RDR_ALTM_DIS, name 	= 'RDR ALTM Disable'	      , category = 'LASTE Control Panel'},


-- Engine Control Panel

{down = iCommandPlane_LG_WRN_Silence		, up = iCommandPlane_LG_WRN_Silence		, name = 'Landing Gear Warning Silence'			, category = 'Engine Control Panel'};
{down = iCommandPlane_APU_Start														, name = 'APU Start'							, category = 'Engine Control Panel'};
{down = iCommandPlane_APU_Off														, name = 'APU Off'								, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_OPER_Ign 		, up = iCommandPlane_L_ENG_OPER_Norm	, name = 'Left Engine Oper Ign / Norm'			, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_OPER_Motor												, name = 'Left Engine Oper Motor'				, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_OPER_Norm												, name = 'Left Engine Oper Norm'				, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_OPER_Ign 		, up = iCommandPlane_R_ENG_OPER_Norm	, name = 'Right Engine Oper Ign / Norm'			, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_OPER_Motor												, name = 'Right Engine Oper Motor'				, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_OPER_Norm												, name = 'Right Engine Oper Norm'				, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_FUEL_FLOW_Norm											, name = 'Left Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};
{down = iCommandPlane_L_ENG_FUEL_FLOW_Override										, name = 'Left Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_FUEL_FLOW_Norm											, name = 'Right Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};
{down = iCommandPlane_R_ENG_FUEL_FLOW_Override										, name = 'Right Engine Fuel Flow Norm/Override'	, category = 'Engine Control Panel'};



--NightVision
{down    = iCommandViewNightVisionGogglesOn   , name = 'Toggle goggles'   , category = 'Sensors'},
{pressed = iCommandPlane_Helmet_Brightess_Up  , name = 'Gain goggles up'  , category = 'Sensors'},
{pressed = iCommandPlane_Helmet_Brightess_Down, name = 'Gain goggles down', category = 'Sensors'},

-- Auto Lock On
{down = iCommandAutoLockOnNearestAircraft, name = 'Auto lock on nearest aircraft', category = 'Targeting'},
{down = iCommandAutoLockOnCenterAircraft, name = 'Auto lock on center aircraft', category = 'Targeting'},
{down = iCommandAutoLockOnNextAircraft, name = 'Auto lock on next aircraft', category = 'Targeting'},
{down = iCommandAutoLockOnPreviousAircraft, name = 'Auto lock on previous aircraft', category = 'Targeting'},
{down = iCommandAutoLockOnNearestSurfaceTarget, name = 'Auto lock on nearest surface target', category = 'Targeting'},
{down = iCommandAutoLockOnCenterSurfaceTarget, name = 'Auto lock on center surface target', category = 'Targeting'},
{down = iCommandAutoLockOnNextSurfaceTarget, name = 'Auto lock on next surface target', category = 'Targeting'},
{down = iCommandAutoLockOnPreviousSurfaceTarget, name = 'Auto lock on previous surface target', category = 'Targeting'},
{down = iCommandAutoLockOnClear, name = 'Clear Selected Target', category = 'Targeting'},
{down = iCommandEasyRadarOnOff, name = 'Easy Radar toggle', category = 'Targeting'},

{down = iCommandEasyRadarScaleUp , name = 'Easy Radar scale in' , category = 'Targeting'},
{down = iCommandEasyRadarScaleOut, name = 'Easy Radar scale out', category = 'Targeting'},

{pressed = iCommandSelecterUp   , up = iCommandSelecterStop, name = 'Selector up'   , category = 'Targeting'},
{pressed = iCommandSelecterDown , up = iCommandSelecterStop, name = 'Selector down' , category = 'Targeting'},
{pressed = iCommandSelecterLeft , up = iCommandSelecterStop, name = 'Selector left' , category = 'Targeting'},
{pressed = iCommandSelecterRight, up = iCommandSelecterStop, name = 'Selector right', category = 'Targeting'},
{down = iCommandPlaneChangeWeapon, name = 'Change Weapon', category = 'Weapons'},

},

axisCommands = {

-- joystick axes 
{combos = {{key = 'JOY_X'}}, action = iCommandPlaneRoll, name = 'Roll'},
{combos = {{key = 'JOY_Y'}}, action = iCommandPlanePitch, name = 'Pitch'},
{combos = {{key = 'JOY_RZ'}}, action = iCommandPlaneRudder, name = 'Rudder'},
{combos = {{key = 'JOY_SLIDER1'}}, action = iCommandPlaneThrustCommon, name = 'Throttle Common'},

-- TrackIR axes
{action = iCommandViewVerticalAbs		, name = 'Absolute Camera Vertical View'},
{action = iCommandViewHorizontalAbs		, name = 'Absolute Camera Horizontal View'},
{action = iCommandViewHorTransAbs		, name = 'Absolute Horizontal Shift Camera View'},
{action = iCommandViewVertTransAbs		, name = 'Absolute Vertical Shift Camera View'},
{action = iCommandViewLongitudeTransAbs	, name = 'Absolute Longitude Shift Camera View'},
{action = iCommandViewRollAbs			, name = 'Absolute Roll Shift Camera View'},
{action = iCommandViewZoomAbs			, name = 'Zoom View'},

{action = iCommandPlaneThrustLeft , name = 'Throttle Left'},
{action = iCommandPlaneThrustRight, name = 'Throttle Right'},

{action = iCommandWheelBrake,		name = 'Wheel Brake'},
{action = iCommandLeftWheelBrake,	name = 'Wheel Brake Left'},
{action = iCommandRightWheelBrake,	name = 'Wheel Brake Right'},

{action = iCommandPlaneSelecterHorizontalAbs, name = 'HOTAS Slew Horizontal'},
{action = iCommandPlaneSelecterVerticalAbs	, name = 'HOTAS Slew Vertical'},

},
}
end
